package com.sharkysoft.printf;

import com.sharkysoft.printf.engine.NumberFormatter;
import com.sharkysoft.util.UnreachableCodeException;

class Formatter_x extends Formatter_Integer
{

  Formatter_x(final FormatSpecifier ipPfs)
  {
    super(ipPfs);
    final NumberFormatter vpNf = (NumberFormatter) mpFormatter;
    vpNf.setRadix(16);
    switch (ipPfs.mcType)
    {
    case 'x' :
      if (ipPfs.mcAlternate == FormatSpecifier.ALTERNATE_ON)
      {
        vpNf.setZeroPrefix("0x");
        vpNf.setPosPrefix("0x");
      }
      vpNf.setUpperCase(false);
      break;
    case 'X' :
      if (ipPfs.mcAlternate == FormatSpecifier.ALTERNATE_ON)
      {
        vpNf.setZeroPrefix("0X");
        vpNf.setPosPrefix("0X");
      }
      vpNf.setUpperCase(true);
      break;
    default :
      throw new UnreachableCodeException();
    }
  }

  void format(final PrintfState ipPs)
  {
    formatUnsignedInt(ipPs);
  }
  
}

