package com.sharkysoft.printf;

/**
 * Signals malformed printf format.
 *
 * <p><b>Details:</b>  Printf for Java throws a 
 * <code>PrintfTemplateException</code> whenever an attempt is made to parse an
 * invalid format string or apply illegal arguments to a valid format string.  
 * This exception almost always indicates a bug in the
 * client code.</p>
 *
 * <blockquote class="example">
 *
 *   <p><b>Example 1:</b> Invalid format string:</p>
 *
    *<blockquote><pre>
      *float tax_increase = SOME_VALUE;
      *Printf.out
      *( "taxes raised by %f% this year",
      *   new Object[] {new Float(tax_increase)}
      *);
    *</pre></blockquote>
 *
 *   <p>When this code is executed, the format string parser interprets the
 *   second percent character as the beginning of a second format specifier.
 *   But since the following character, '<tt>t</tt>', does not correspond to a
 *   legal printf conversion type, a <code>PrintfTemplateException</code> will be
 *   thrown.  (The correct format string should read "<tt>taxes raised by %f%%
 *   this year</tt>".)</p>
 *
 * </blockquote>
 *
 * <p>Even if a format string is syntactically correct, a
 * <code>PrintfTemplateException</code> can still be thrown if variable widths and
 * precisions are used and the supplied arguments are invalid.</p>
 *
 * <blockquote class="example">
 *
 *   <p><b>Example 2:</b> Valid format string with invalid arguments:</p>
 *
    *<blockquote><pre>
      *int dec_places = -3;
      *Printf.out
      *( "pi rounded to %d decimal places is %.*f",
      *  new PrintfData(3)
      *  .add(dec_places) // intended for "%d"
      *  .add(dec_places) // intended for "%.*f"
      *  .add(Math.PI)
      *);
    *</pre></blockquote>
 *
 *   <p>This code throws a <code>PrintfTemplateException</code> because the variable precision
 *   specified by "%.*f" cannot be set to -3.</p>
 *
 * </blockquote>
 *
 * <p>For more information on printf formatting, see <code>Printf</code>.</p>
 *
 * @see Printf
 * 
 * @author Sharky
 */
public class PrintfTemplateException extends IllegalArgumentException
{

  /**
   * Initializes with detail message.
   *
   * <p><b>Details:</b> This constructor initializes the new exception with the
   * supplied detail message.</p>
   *
   * @param isDetail the detail message
   */
  PrintfTemplateException(final String isDetail)
  {
    super(isDetail);
  }

}

