/*
 * Decompiled with CFR 0.152.
 */
package com.sharkysoft.math;

import java.math.BigDecimal;

public final class MantissaExponent {
    public static final int NAN = 0;
    public static final int NEG_INF = -1;
    public static final int POS_INF = 1;
    private static final BigDecimal gpBdNan = new BigDecimal(0.0);
    private static final BigDecimal gpBdNegInf = new BigDecimal(-1.0);
    private static final BigDecimal gpBdPosInf = new BigDecimal(1.0);
    private static final BigDecimal gpBdPos10 = BigDecimal.valueOf(10L);
    private static final BigDecimal gpBdNeg10 = BigDecimal.valueOf(-10L);
    private static final BigDecimal gpBdPos1 = BigDecimal.valueOf(1L);
    private static final BigDecimal gpBdNeg1 = BigDecimal.valueOf(-1L);
    protected final BigDecimal mpMantissa;
    protected final int mnExponent;

    public BigDecimal getMantissa() {
        return this.mpMantissa;
    }

    public int getExponent() {
        return this.mnExponent;
    }

    MantissaExponent(BigDecimal ipBig) {
        if (ipBig == gpBdNan || ipBig == gpBdNegInf || ipBig == gpBdPosInf) {
            this.mpMantissa = null;
            this.mnExponent = ipBig.intValue();
            return;
        }
        int vnExponent = 0;
        switch (ipBig.signum()) {
            case 1: {
                if (ipBig.compareTo(gpBdPos10) >= 0) {
                    do {
                        ipBig = ipBig.movePointLeft(1);
                        ++vnExponent;
                    } while (ipBig.compareTo(gpBdPos10) >= 0);
                    break;
                }
                if (ipBig.compareTo(gpBdPos1) >= 0) break;
                do {
                    ipBig = ipBig.movePointRight(1);
                    --vnExponent;
                } while (ipBig.compareTo(gpBdPos1) < 0);
                break;
            }
            case -1: {
                if (ipBig.compareTo(gpBdNeg10) <= 0) {
                    do {
                        ipBig = ipBig.movePointLeft(1);
                        ++vnExponent;
                    } while (ipBig.compareTo(gpBdNeg10) <= 0);
                    break;
                }
                if (ipBig.compareTo(gpBdNeg1) <= 0) break;
                do {
                    ipBig = ipBig.movePointRight(1);
                    --vnExponent;
                } while (ipBig.compareTo(gpBdNeg1) > 0);
            }
        }
        this.mpMantissa = ipBig;
        this.mnExponent = vnExponent;
    }

    private static BigDecimal getBig(float ifValue) {
        if (ifValue == Float.POSITIVE_INFINITY) {
            return gpBdPosInf;
        }
        if (ifValue == Float.NEGATIVE_INFINITY) {
            return gpBdNegInf;
        }
        if (Float.isNaN(ifValue)) {
            return gpBdNan;
        }
        return new BigDecimal(ifValue);
    }

    MantissaExponent(float ifVal) {
        this(MantissaExponent.getBig(ifVal));
    }

    private static BigDecimal getBig(double idValue) {
        if (idValue == Double.POSITIVE_INFINITY) {
            return gpBdPosInf;
        }
        if (idValue == Double.NEGATIVE_INFINITY) {
            return gpBdNegInf;
        }
        if (Double.isNaN(idValue)) {
            return gpBdNan;
        }
        return new BigDecimal(idValue);
    }

    MantissaExponent(double idVal) {
        this(MantissaExponent.getBig(idVal));
    }

    public String toString() {
        if (this.mpMantissa == gpBdNan) {
            return Float.toString(Float.NaN);
        }
        if (this.mpMantissa == gpBdNegInf) {
            return Float.toString(Float.NEGATIVE_INFINITY);
        }
        if (this.mpMantissa == gpBdPosInf) {
            return Float.toString(Float.POSITIVE_INFINITY);
        }
        return this.mpMantissa + "*10^" + this.mnExponent;
    }
}

