package com.sharkysoft.math;

import java.math.BigDecimal;

/**
 * Math-related functions.
 *
 * <p><b>Details:</b> <code>MathToolbox</code> is a miscellaneous collection of 
 * generic math-<wbr>related functions.</p>
 *
 * @author Sharky
 */
public class MathToolbox
{

	////////////////////////////
	//                        //
	//  toScientificNotation  //
	//                        //
	////////////////////////////

	/**
	 * Converts real value to scientific notation.
	 *
	 * <p><b>Details:</b> This method determines the scientific notation for the
	 * given real value.</p>
	 *
	 * @param ipVal the real value
	 * @return the scientific notation
	 */
	public static MantissaExponent toScientificNotation(final BigDecimal ipVal)
	{
		return new MantissaExponent(ipVal);
	}

	/**
	 * Converts real value to scientific notation.
	 *
	 * <p><b>Details:</b> This method determines the scientific notation for the
	 * given real value.</p>
	 *
	 * @param idVal the real value
	 * @return the scientific notation
	 */
	public static MantissaExponent toScientificNotation(final double idVal)
	{
		return new MantissaExponent(idVal);
	}

	/**
	 * Converts real value to scientific notation.
	 *
	 * <p><b>Details:</b> This method determines the scientific notation for the
	 * given real value.</p>
	 *
	 * @param ifVal the real value
	 * @return the scientific notation
	 */
	public static MantissaExponent toScientificNotation(final float ifVal)
	{
		return new MantissaExponent(ifVal);
	}

	public static boolean isIrrational(final float ifValue)
	{
		return Float.isNaN(ifValue) || Float.isInfinite(ifValue);
	}

	public static boolean isIrrational(final double idValue)
	{
		return Double.isNaN(idValue) || Double.isInfinite(idValue);
	}

}

